<?php

namespace Ipay\EmailClient;

use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\SMTP;
use PHPMailer\PHPMailer\Exception;

class Client
{
    public $to;
    public $from;
    public $cc;
    public $subject;
    public $message;
    private $setUp = 'lib';

    public function __construct()
    {
    }

    public function to($to='')
    {
        $this->to = $to;

        return $this;
    }

    public function from($from='')
    {
        $this->from = $from;

        return $this;
    }

    public function cc(array $cc = [])
    {
        if (empty($cc)){
            return null;
        }

        $emails = implode(" ", $cc);
        $this->cc = $emails;

        return $this;
    }

    public function subject($subject='')
    {
        $this->subject = $subject;

        return $this;
    }

    public function message($message='')
    {
        $this->message = $message;

        return $this;
    }

    private function normal_php_func()
    {
        $from = 'no-reply@'.str_replace('www.', '', $_SERVER['SERVER_NAME']);

        $headers = "MIME-Version: 1.0" . "\r\n";
        $headers .= "Content-type:text/html;charset=UTF-8" . "\r\n";
        $headers .= "From: {$from}" . "\r\n";

        if (!empty($this->cc)) {
            $headers .= "Cc: $this->cc" . "\r\n";
        }

        try {
            if (mail($this->to, $this->subject, $this->message, $headers)) {
                return $this->reply_message('Mail sent successfully', 200);
            }
        } catch (\Exception $e) {
            return $this->reply_message("Mail not sent", 400);
        }
    }

    private function php_mailer_lib()
    {
        $mail = new PHPMailer(true);

        try {
            //Server settings
            //$mail->SMTPDebug = SMTP::DEBUG_SERVER;                      //Enable verbose debug output
            $mail->isSMTP();                                            //Send using SMTP
            $mail->Host       = 'mail.opeafrica.org';                     //Set the SMTP server to send through
            $mail->SMTPAuth   = true;                                   //Enable SMTP authentication
            $mail->Username   = 'noreply@opeafrica.org';                     //SMTP username
            $mail->Password   = 'qw6%uoOdYZal';                               //SMTP password
            $mail->SMTPSecure = PHPMailer::ENCRYPTION_SMTPS;            //Enable implicit TLS encryption
            $mail->Port       = 465;                                    //TCP port to connect to; use 587 if you have set `SMTPSecure = PHPMailer::ENCRYPTION_STARTTLS`

            //Recipients
            $mail->setFrom('noreply@opeafrica.org', 'noreply');
            $mail->addAddress($this->to);
            if (!empty($this->cc)) {
                $mail->addCC($this->cc);
            }            

            //Content
            $mail->isHTML(true);                                  //Set email format to HTML
            $mail->Subject = $this->subject;
            $mail->Body    = $this->message;

            $mail->send();
            
            return $this->reply_message('Mail sent successfully', 200);
        } catch (Exception $e) {
            return $this->reply_message("Message could not be sent. Mailer Error: {$mail->ErrorInfo}", 400);
        }
    }

    public function send()
    {       
        if($this->setUp == 'lib') {
            return $this->php_mailer_lib();
        }

        return $this->normal_php_func();        
    }

    private function reply_message($content, $code)
    {
        return json_encode([
            'status' => $code,
            'message' => $content
        ]);
    }
}

